
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Transactions;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
    [TestFixture]
    public class DAL_PendingBloodUnitTest : BaseTest
    {
        [Test]
        [Category("UC_115_AutomatedTesting")]
        public void GetPendingBloodUnitTest_Pass()
        {
            using (TransactionScope scope = new TransactionScope())
            {                
                // Arrange
                InsertData();

                //Act
                var dtPendingBloodUnitTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PendingBloodUnitTest WHERE PendingTestStatusId = 1 AND DivisionCode = '" + this.TestDivisionCode + "'", false);
                
                // Assert
                Assert.IsTrue(dtPendingBloodUnitTest.Rows.Count > 0);
            }
        }


        private void InsertData()
        {
            BOL.BloodUnit tmpUnit = DataCreator.CreateRBCBloodUnit(false);

            string sql =
            "INSERT [dbo].[PendingBloodUnitTest] ([BloodUnitTestGuid], [BloodUnitGuid], [BloodTestTypeId], [BloodUnitId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentComments], [OrderedTestGuid], [OrderedComponentGuid], [AutoInstrumentName], [DivisionCode], [PendingTestStatusId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId], [UnitResultSetGuid]) VALUES (NULL, N'" + tmpUnit.BloodUnitGuid.ToString() +"', 15, N'" + tmpUnit.LabelUnitId + "', CAST(N'2015-12-08 12:30:00.000' AS DateTime), N'DNS   VBECS1', N'2  ', N'instrument comment', NULL, NULL, N'ProVue', N'589  ', 1, CAST(N'2015-12-08 12:31:00.000' AS DateTime), N'DNS   VBECS1', 81, N'714fad8e-0691-4720-a67f-0017dbb6bb44')" +
            "INSERT [dbo].[PendingBloodUnitTest] ([BloodUnitTestGuid], [BloodUnitGuid], [BloodTestTypeId], [BloodUnitId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentComments], [OrderedTestGuid], [OrderedComponentGuid], [AutoInstrumentName], [DivisionCode], [PendingTestStatusId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId], [UnitResultSetGuid]) VALUES (NULL, N'" + tmpUnit.BloodUnitGuid.ToString() + "', 16, N'" + tmpUnit.LabelUnitId + "', CAST(N'2015-12-08 12:30:00.000' AS DateTime), N'DNS   VBECS1', N'0  ', N'instrument comment', NULL, NULL, N'ProVue', N'589  ', 1, CAST(N'2015-12-08 12:31:00.000' AS DateTime), N'DNS   VBECS1', 81, N'714fad8e-0691-4720-a67f-0017dbb6bb44')" +
            "INSERT [dbo].[PendingBloodUnitTest] ([BloodUnitTestGuid], [BloodUnitGuid], [BloodTestTypeId], [BloodUnitId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentComments], [OrderedTestGuid], [OrderedComponentGuid], [AutoInstrumentName], [DivisionCode], [PendingTestStatusId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId], [UnitResultSetGuid]) VALUES (NULL, N'" + tmpUnit.BloodUnitGuid.ToString() + "', 17, N'" + tmpUnit.LabelUnitId + "', CAST(N'2015-12-08 12:30:00.000' AS DateTime), N'DNS   VBECS1', N'2  ', N'instrument comment', NULL, NULL, N'ProVue', N'589  ', 1, CAST(N'2015-12-08 12:31:00.000' AS DateTime), N'DNS   VBECS1', 81, N'714fad8e-0691-4720-a67f-0017dbb6bb44')" +
            "INSERT [dbo].[PendingBloodUnitTest] ([BloodUnitTestGuid], [BloodUnitGuid], [BloodTestTypeId], [BloodUnitId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentComments], [OrderedTestGuid], [OrderedComponentGuid], [AutoInstrumentName], [DivisionCode], [PendingTestStatusId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId], [UnitResultSetGuid]) VALUES (NULL, N'" + tmpUnit.BloodUnitGuid.ToString() + "', 18, N'" + tmpUnit.LabelUnitId + "', CAST(N'2015-12-08 12:30:00.000' AS DateTime), N'DNS   VBECS1', N'A  ', N'instrument comment', NULL, NULL, N'ProVue', N'589  ', 1, CAST(N'2015-12-08 12:31:00.000' AS DateTime), N'DNS   VBECS1', 81, N'714fad8e-0691-4720-a67f-0017dbb6bb44')" +
            "INSERT [dbo].[PendingBloodUnitTest] ([BloodUnitTestGuid], [BloodUnitGuid], [BloodTestTypeId], [BloodUnitId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentComments], [OrderedTestGuid], [OrderedComponentGuid], [AutoInstrumentName], [DivisionCode], [PendingTestStatusId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId], [UnitResultSetGuid]) VALUES (NULL, N'" + tmpUnit.BloodUnitGuid.ToString() + "', 19, N'" + tmpUnit.LabelUnitId + "', CAST(N'2015-12-08 12:30:00.000' AS DateTime), N'DNS   VBECS1', N'2  ', N'instrument comment', NULL, NULL, N'ProVue', N'589  ', 1, CAST(N'2015-12-08 12:31:00.000' AS DateTime), N'DNS   VBECS1', 81, N'714fad8e-0691-4720-a67f-0017dbb6bb44')" +
            "INSERT [dbo].[PendingBloodUnitTest] ([BloodUnitTestGuid], [BloodUnitGuid], [BloodTestTypeId], [BloodUnitId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentComments], [OrderedTestGuid], [OrderedComponentGuid], [AutoInstrumentName], [DivisionCode], [PendingTestStatusId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId], [UnitResultSetGuid]) VALUES (NULL, N'" + tmpUnit.BloodUnitGuid.ToString() + "', 20, N'" + tmpUnit.LabelUnitId + "', CAST(N'2015-12-08 12:30:00.000' AS DateTime), N'DNS   VBECS1', N'0  ', N'instrument comment', NULL, NULL, N'ProVue', N'589  ', 1, CAST(N'2015-12-08 12:31:00.000' AS DateTime), N'DNS   VBECS1', 81, N'714fad8e-0691-4720-a67f-0017dbb6bb44')" +
            "INSERT [dbo].[PendingBloodUnitTest] ([BloodUnitTestGuid], [BloodUnitGuid], [BloodTestTypeId], [BloodUnitId], [TestDate], [TestTechId], [TestResultId], [AutoInstrumentComments], [OrderedTestGuid], [OrderedComponentGuid], [AutoInstrumentName], [DivisionCode], [PendingTestStatusId], [LastUpdateDate], [LastUpdateUser], [LastUpdateFunctionId], [UnitResultSetGuid]) VALUES (NULL, N'" + tmpUnit.BloodUnitGuid.ToString() + "', 21, N'" + tmpUnit.LabelUnitId + "', CAST(N'2015-12-08 12:30:00.000' AS DateTime), N'DNS   VBECS1', N'P  ', N'instrument comment', NULL, NULL, N'ProVue', N'589  ', 1, CAST(N'2015-12-08 12:31:00.000' AS DateTime), N'DNS   VBECS1', 81, N'714fad8e-0691-4720-a67f-0017dbb6bb44')";
            UnitTestUtil.RunSQL(sql);
        }

        private void DeleteTableData()
        {
            UnitTestUtil.RunSQL("DELETE PendingBloodUnitTest");
        }
    }
}


#endif



